#include <stdio.h>
#include <stdlib.h>

#define MAXN 20000

typedef struct {
    double x, y;
    int idx;
} Point;

int main() {
    int n;
    double eps;
    scanf("%d %lf", &n, &eps);

    Point p[MAXN];
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &p[i].x, &p[i].y);
        p[i].idx = i + 1;
    }

    int G = (int)(1.0 / (2 * eps)) + 2;
    if (G > 2000) G = 2000;

    static char used[2000][2000];
    for (int i = 0; i < G; i++)
        for (int j = 0; j < G; j++)
            used[i][j] = 0;

    int Q[MAXN];
    int qn = 0;

    for (int i = 0; i < n; i++) {
        int gx = (int)(p[i].x / (2 * eps));
        int gy = (int)(p[i].y / (2 * eps));

        if (gx >= G) gx = G - 1;
        if (gy >= G) gy = G - 1;

        if (!used[gx][gy]) {
            used[gx][gy] = 1;
            Q[qn++] = p[i].idx;
        }
    }

    printf("%d\n", qn);
    for (int i = 0; i < qn; i++)
        printf("%d ", Q[i]);
    printf("\n");

    for (int i = 1; i < qn; i++)
        printf("%d %d\n", Q[i - 1], Q[i]);

    return 0;
}